/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import javax.annotation.Nullable;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2488;
import net.minecraft.class_2493;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3558;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerWorld;

public class SlimeGrassBlock
extends class_2493
implements class_2256 {
    private final SlimeType foliageType;

    public SlimeGrassBlock(class_4970.class_2251 properties, SlimeType foliageType) {
        super(properties);
        this.foliageType = foliageType;
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state, boolean isClient) {
        return world.method_8320(pos.method_10084()).method_26215();
    }

    public boolean method_9650(class_1937 worldIn, class_5819 rand, class_2338 pos, class_2680 state) {
        return true;
    }

    public static void growGrass(class_3218 world, class_5819 rand, class_2338 pos, class_6862<class_2248> validBase, SlimeType foliageType, boolean includeSapling, boolean spread) {
        class_2338 up = pos.method_10084();
        block0: for (int i = 0; i < 128; ++i) {
            int plant;
            class_2680 plantState;
            class_2338 target = up;
            for (int j = 0; j < i / 16; ++j) {
                target = target.method_10069(rand.method_43048(3) - 1, (rand.method_43048(3) - 1) * rand.method_43048(3) / 2, rand.method_43048(3) - 1);
                class_2338 below = target.method_10074();
                class_2680 belowState = world.method_8320(below);
                if (world.method_8320(target).method_26234((class_1922)world, target)) continue block0;
                if (spread && TinkerWorld.allDirt.contains(belowState.method_26204())) {
                    class_2680 grassState = SlimeGrassBlock.getStateFromDirt(belowState, foliageType);
                    if (grassState == null) continue block0;
                    world.method_8501(below, grassState);
                    continue block0;
                }
                if (!belowState.method_26164(validBase)) continue block0;
            }
            if (!world.method_22347(target) || !(plantState = (plant = rand.method_43048(32)) == 0 && includeSapling ? TinkerWorld.slimeSapling.get(foliageType).method_9564() : (plant < 6 ? TinkerWorld.slimeFern.get(foliageType).method_9564() : TinkerWorld.slimeTallGrass.get(foliageType).method_9564())).method_26184((class_4538)world, target)) continue;
            world.method_8652(target, plantState, 3);
        }
    }

    public void method_9652(class_3218 world, class_5819 rand, class_2338 pos, class_2680 state) {
        SlimeGrassBlock.growGrass(world, rand, pos, TinkerTags.Blocks.SLIMY_GRASS, this.foliageType, false, false);
    }

    @Deprecated
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!world.isAreaLoaded(pos, 3)) {
            return;
        }
        if (!SlimeGrassBlock.isValidPos(state, (class_4538)world, pos)) {
            world.method_8501(pos, SlimeGrassBlock.getDirtState(state));
        } else if (world.method_22339(pos.method_10084()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                class_2338 newGrass = pos.method_10069(random.method_43048(3) - 1, random.method_43048(5) - 3, random.method_43048(3) - 1);
                class_2680 newState = SlimeGrassBlock.getStateFromDirt(world.method_8320(newGrass), this.foliageType);
                if (newState == null || !SlimeGrassBlock.canSpread(newState, (class_4538)world, newGrass)) continue;
                world.method_8501(newGrass, (class_2680)newState.method_11657((class_2769)field_11522, (Comparable)Boolean.valueOf(world.method_8320(newGrass.method_10084()).method_27852(class_2246.field_10477))));
            }
        }
    }

    private static boolean isValidPos(class_2680 targetState, class_4538 world, class_2338 pos) {
        class_2338 above = pos.method_10084();
        class_2680 aboveState = world.method_8320(above);
        if (aboveState.method_27852(class_2246.field_10477) && (Integer)aboveState.method_11654((class_2769)class_2488.field_11518) == 1) {
            return true;
        }
        if (aboveState.method_26227().method_15761() == 8) {
            return false;
        }
        return class_3558.method_20049((class_1922)world, (class_2680)targetState, (class_2338)pos, (class_2680)aboveState, (class_2338)above, (class_2350)class_2350.field_11036, (int)aboveState.method_26193((class_1922)world, above)) < world.method_8315();
    }

    private static boolean canSpread(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 above = pos.method_10084();
        return SlimeGrassBlock.isValidPos(state, world, pos) && !world.method_8316(above).method_15767(class_3486.field_15517);
    }

    public static class_2680 getDirtState(class_2680 grassState) {
        class_2248 block = grassState.method_26204();
        for (SlimeType type : SlimeType.values()) {
            if (!TinkerWorld.slimeGrass.get((Object)type).contains(block)) continue;
            return TinkerWorld.allDirt.get(type).method_9564();
        }
        return class_2246.field_10566.method_9564();
    }

    @Nullable
    public static class_2680 getStateFromDirt(class_2680 dirtState, SlimeType foliageType) {
        class_2248 block = dirtState.method_26204();
        for (SlimeType type : SlimeType.values()) {
            if (TinkerWorld.allDirt.get(type) != block) continue;
            return TinkerWorld.slimeGrass.get((Object)type).get(foliageType).method_9564();
        }
        return null;
    }

    public SlimeType getFoliageType() {
        return this.foliageType;
    }
}

